<?php
/*
 * Template Name: Brands Template
 */
$content = get_queried_object();
$args = array(
    'taxonomy' => 'brand',
    'hide_empty' => false,
    'hierarchical' => true,
);
$terms = get_terms($args);
get_header();
?>
<section class="text-gray-600 body-font">
    <div class="container px-5 py-24 mx-auto">
        <div class="flex flex-wrap w-full mb-20">
            <div class="lg:w-1/2 w-full mb-6 lg:mb-0">
                <h1 class="sm:text-3xl text-2xl font-medium title-font mb-2 text-gray-900"><?= the_title(); ?></h1>
                <div class="h-1 w-20 bg-indigo-500 rounded"></div>
            </div>
            <div class="lg:w-1/2 w-full leading-relaxed text-gray-500"><?= get_the_content(); ?></div>
        </div>
        <div class="flex flex-wrap -m-4">
            <?php foreach ($terms as $term) :
                $permalink = get_term_link($term->term_id);
                $featured_img = get_field('logo', $term->taxonomy . '_' . $term->term_id);
                ?>
                <div class="xl:w-1/4 md:w-1/2 p-4">
                    <a href="<?= $permalink; ?>">
                        <div class="bg-gray-100 p-6 rounded-lg">
                            <img class="h-40 rounded w-full object-cover object-center mb-6"
                                 src="<?= $featured_img['url']; ?>" alt="content">
                            <h2 class="text-lg text-gray-900 font-medium title-font mb-4"><?= $term->name; ?></h2>
                            <div class="leading-relaxed text-sm"><?= $term->description; ?></div>
                        </div>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php get_footer(); ?>
