# Tailwind Elements [<img src="https://tailwind-elements.com/img/logo.png" width="45" align="right" alt="Tailwind-elements">](https://tailwind-elements.com/)<a href="https://www.npmjs.com/package/tw-elements"><img src="https://img.shields.io/npm/dt/tw-elements.svg" alt="Total Downloads"></a> <a href="https://github.com/mdbootstrap/Tailwind-Elements/releases"><img src="https://img.shields.io/npm/v/tw-elements.svg" alt="Latest Release"></a> <a href="https://twitter.com/intent/tweet/?text=Thanks+@TailwindElement+for+creating+an+amazing+collection+of+open+source+components+for+@tailwindcss%20https://tailwind-elements.com/&hashtags=tailwindCSS,bootstrap,webdesign,javascript,100DaysOfCode,DevCommunity"><img src="https://img.shields.io/twitter/url/http/shields.io.svg?style=social&label=Let%20us%20know%20you%20were%20here%21&"></a>

Tailwind Elements **is a plugin** that extends the functionality of the library with many interactive components.

In some dynamic components (like dropdowns or modals) we add Font Awesome icons and custom JavaScript. However, they do not require any additional installation, all the necessary code is always included in the example and copied to any Tailwind project - it will work.

  <table>
    <tbody>
    <tr>
      <td>
          <a href="https://tailwind-elements.com/" alt="Tailwind-elements" rel="dofollow">
          		<img src="https://tailwind-elements.com/img/tailwind-video.png">
          </a>
      </td>
      <td>
       <p><b>Bootstrap components recreated with Tailwind CSS, but with better design and more functionalities.</b></p>
        <ul>
         <li>500+ UI components</li>
         <li>Super simple, 1 minute installation</li>
         <li>Free hosting</li>
         <li><b>MIT license - free for personal & commercial use</b></li>
        </ul>
      </td>
    </tr>
   </tbody>
  </table>
 
 <table>
  <tr>
    <td>
        <a href="https://tailwind-elements.com/#section-components">
            <img alt="Components" src="https://mdbootstrap.com/img/tw-demo/components.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/#section-blocks">
            <img alt="Design blocks" src="https://mdbootstrap.com/img/tw-demo/design-blocks.webp">
        </a>
    </td>
    <td>
        <a href="#">
            <img alt="Templates" src="https://mdbootstrap.com/img/tw-demo/templates.webp">
        </a>
    </td>
  </tr>
    <tr>
    <td align="center"><b>Components</b></td>
    <td align="center"><b>Design blocks (sections)</b></td>
    <td align="center"><b>Templates (coming soon)</b></td>
  </tr>
  <tr>
    <td>
        <a href="https://mdbgo.com/">
            <img alt="Free hosting" src="https://mdbootstrap.com/img/tw-demo/free-hosting.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/snippets/">
            <img alt="Playground" src="https://mdbootstrap.com/img/tw-demo/playground.webp">
        </a>
    </td>
    <td>
        <a href="https://mdb-builder.com/">
            <img alt="Drag & drop builder" src="https://mdbootstrap.com/img/tw-demo/drag-and-drop.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Free hosting</b></td>
    <td align="center"><b>Playground</b></td>
    <td align="center"><b>Drag & drop builder (coming soon)</b></td>
  </tr>
</table>

# Components

Collection of free, popular components like modal, dropdown, carousel, popover, cards, charts and many more.

<table>
  <tr>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/forms/datepicker/">
            <img alt="Datepicker" src="https://mdbootstrap.com/img/tw-demo/datepicker.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/components/dropdown/">
            <img alt="Dropdown" src="https://mdbootstrap.com/img/tw-demo/dropdown.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/components/modal/">
            <img alt="Modal" src="https://mdbootstrap.com/img/tw-demo/modal.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Datepicker</b></td>
    <td align="center"><b>Dropdown</b></td>
    <td align="center"><b>Modal</b></td>
  </tr>
  
  <tr>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/components/charts/">
            <img alt="Charts" src="https://mdbootstrap.com/img/tw-demo/charts.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/components/tooltip/">
            <img alt="Tooltips" src="https://mdbootstrap.com/img/tw-demo/tooltips-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/components/carousel/">
            <img alt="Carousel" src="https://mdbootstrap.com/img/tw-demo/carousel.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Charts</b></td>
    <td align="center"><b>Tooltips</b></td>
    <td align="center"><b>Carousel</b></td>
  </tr>
  
  <tr>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/components/accordion/">
            <img alt="Accordion" src="https://mdbootstrap.com/img/tw-demo/accordion.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/navigation/tabs/">
            <img alt="Tabs" src="https://mdbootstrap.com/img/tw-demo/tabs.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/components/stepper//">
            <img alt="Stepper" src="https://mdbootstrap.com/img/tw-demo/stepper.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Accordion</b></td>
    <td align="center"><b>Tabs</b></td>
    <td align="center"><b>Stepper</b></td>
  </tr>
  <tr>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/forms/timepicker/">
            <img alt="Tailwind CSS Progress Bar" src="https://mdbootstrap.com/img/tw-demo/timepicker.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/navigation/footer/">
            <img alt="Tailwind CSS Tables" src="https://mdbootstrap.com/img/tw-demo/footer.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/navigation/navbar/">
            <img alt="Tailwind CSS Toast" src="https://mdbootstrap.com/img/tw-demo/navbar.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Accordion</b></td>
    <td align="center"><b>Tabs</b></td>
    <td align="center"><b>Stepper</b></td>
  </tr>
</table>

<p align="center">
  <a href="https://tailwind-elements.com/quick-start/">
    <img src="https://v1.mdbootstrap.com/wp-content/uploads/2022/05/view-components-1.png">
  </a>
</p>

# Design blocks

Responsive Landing page blocks built with Tailwind CSS. Plenty of design blocks examples such as Teams, services, projects, faq, and many more.

<table>
  <tr>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/designblocks/hero-sections/">
            <img alt="Hero" src="https://mdbootstrap.com/img/tw-demo/hero.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/designblocks/pricing/">
            <img alt="Pricing" src="https://mdbootstrap.com/img/tw-demo/pricing.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/designblocks/cta/">
            <img alt="Call to action" src="https://mdbootstrap.com/img/tw-demo/cta.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Hero</b></td>
    <td align="center"><b>Pricing</b></td>
    <td align="center"><b>Call to action</b></td>
  </tr>
  
  <tr>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/designblocks/features/">
            <img alt="Features" src="https://mdbootstrap.com/img/tw-demo/features.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/designblocks/contact/">
            <img alt="Contact" src="https://mdbootstrap.com/img/tw-demo/contact.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/designblocks/news/">
            <img alt="News/blog" src="https://mdbootstrap.com/img/tw-demo/news.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Features</b></td>
    <td align="center"><b>Contact</b></td>
    <td align="center"><b>News/blog</b></td>
  </tr>
  
  <tr>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/designblocks/team/">
            <img alt="Accordion" src="https://mdbootstrap.com/img/tw-demo/team.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/designblocks/stats/">
            <img alt="Tabs" src="https://mdbootstrap.com/img/tw-demo/stats.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/designblocks/testimonials/">
            <img alt="Stepper" src="https://mdbootstrap.com/img/tw-demo/testimonials.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Team</b></td>
    <td align="center"><b>Stats</b></td>
    <td align="center"><b>Testimonials</b></td>
  </tr>
  <tr>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/designblocks/content/">
            <img alt="Contact" src="https://mdbootstrap.com/img/tw-demo/content.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/designblocks/newsletter/">
            <img alt="Newsletter" src="https://mdbootstrap.com/img/tw-demo/newsletter.webp">
        </a>
    </td>
    <td>
        <a href="https://tailwind-elements.com/docs/standard/designblocks/project-sections/">
            <img alt="Projects" src="https://mdbootstrap.com/img/tw-demo/projects.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Contact</b></td>
    <td align="center"><b>Newsletter</b></td>
    <td align="center"><b>Projects</b></td>
  </tr>
</table>

<p align="center">
  <a href="https://tailwind-elements.com/docs/standard/designblocks/landing-page/">
    <img src="https://v1.mdbootstrap.com/wp-content/uploads/2022/05/view-design-blocks.png">
  </a>
</p>

## Quick Start tutorial

##### NPM

1. Before starting the project make sure to install [Node.js (LTS)](https://nodejs.org/en/ "Node.js (LTS)") and [TailwindCSS](https://tailwindcss.com/ "TailwindCSS").

2. Run the following command to install the package via NPM:

```
npm install tw-elements
```

3. Tailwind Elements is a plugin and should be included inside the **tailwind.config.js** file. It is also recommended to extend the content array with a js file that loads dynamic component classes:

```javascript
module.exports = {
  content: [
    "./src/**/*.{html,js}",
    "./node_modules/tw-elements/dist/js/**/*.js",
  ],
  plugins: [require("tw-elements/dist/plugin")],
};
```

4.  Dynamic components will work after adding the js file:

```
<script src="./TW-ELEMENTS-PATH/dist/js/index.min.js"></script>
```

Alternatively, you can import it in the following way (bundler version):

```
import 'tw-elements';
```

##### MDB GO / CLI

Create, deploy and host anything with a single command.

1. To start using MDB GO / CLI install it with one command:

```
npm install -g mdb-cli
```

2. Log into the CLI using your MDB account:

```
mdb login
```

3. Initialize a project and choose **Tailwind Elements** from the list:

```
mdb init
```

4. Install the dependencies (inside the project directory):

```
npm install
```

5. Run the app:

```
npm start
```

6. Publish when you're ready:

```
mdb publish
```

##### CDN

You can easily test Tailwind Elements by adding CDN scripts to your classic HTML template without the need for installing any packages.

Add the stylesheet files below in the _head_ section:

```
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />
<link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700,900&display=swap" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tw-elements/dist/css/index.min.css" />
<script src="https://cdn.tailwindcss.com"></script>
<script>
  tailwind.config = {
    theme: {
      extend: {
        fontFamily: {
          sans: ['Roboto', 'sans-serif'],
        },
      }
    }
  }
</script>
```

Require the js bundled file right before the _body_ closing tag:

```
<script src="https://cdn.jsdelivr.net/npm/tw-elements/dist/js/index.min.js"></script>
```
