<?php
get_header();
$paged    = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
$per_page = 3;
$offset   = ( $paged - 1 ) * $per_page;
$content = get_queried_object();
$query = new WP_Query(array(
    'posts_per_page' => $per_page,
    'offset'         => $offset,
	'page'           => $paged,
    'post_type' => 'product',
    'tax_query' => array(
        array(
            'taxonomy' => $content->taxonomy,
            'field' => $content->name,
            'terms' => $content->term_id,
        )
        ),
));
$featured_img = get_field('image', $content->taxonomy . '_' . $content->term_id);
?>
    <!-- banner -->
<?php get_template_part('template-parts/section-banner', null, array('content' => $content)); ?>

    <!-- products -->
    <section class="body-font mx-auto max-w-[69rem]">
        <div class="container px-5 mx-auto py-14">
            <header class="text-center">
                <h2 class="text-xl font-bold text-gray-900 sm:text-3xl">
                    <?= $content->name; ?> Collection
                </h2>

                <p class="max-w-md mx-auto mt-4 text-gray-500">
                    <?php
                    // if (get_field('short_description', $content->taxonomy . '_' . $content->term_id)) {
                    //     get_field('short_description', $content->taxonomy . '_' . $content->term_id);
                    // } else {
                    //     echo $content->description;
                    // }
                    ?>
                </p>
            </header>

            <ul class="grid grid-cols-2 lg:grid-cols-3 gap-4">
                <?php while ($query->have_posts()) : $query->the_post(); ?>
                    <!-- <li>
                        <a href="<?= get_permalink(); ?>" class="block overflow-hidden group">
                            <img src="<?= get_the_post_thumbnail_url(); ?>" alt=""
                                 class="h-[350px] w-full object-cover transition duration-500 group-hover:scale-105 sm:h-[450px]"/>

                            <div class="relative pt-3 bg-white">
                                <h3 class="text-xs text-gray-700 group-hover:underline group-hover:underline-offset-4"><?= the_title(); ?></h3>
                                <p class="mt-2">
                                    <span class="sr-only"> Regular Price </span>
                                    <span class="tracking-wider text-gray-900"> £24.00 </span>
                                </p>
                            </div>
                        </a>
                    </li> -->

                    <div class="w-full max-w-[380px] mx-auto overflow-hidden">
                        <a href="<?php the_permalink(); ?>" class="relative block group overflow-hidden h-[300px] min-[550px]:h-[420px] sm:h-[450px] ">
                            <div class="absolute w-full h-full top-0 bg-dark lg:opacity-0 lg:group-hover:opacity-30 opacity-30 left-0 z-10 rounded-lg"></div>
                            <img alt="<?= the_title() ?>" src="<?php the_post_thumbnail_url(); ?>"
                                 class="absolute inset-0 object-cover w-full h-full transition-opacity rounded-xl border border-slate-300"/>
                            <div class="relative p-4 sm:p-6 lg:p-8 z-20 lg:group-hover:opacity-100 lg:opacity-0 h-full">
                                <p class="text-sm font-medium tracking-widest uppercase text-mtkn-yellow">
                                    Products
                                </p>
                                <p class="text-base font-bold text-white sm:text-2xl z-20"><?php the_title(); ?></p>
                                <div class="text-white text-[8px] sm:text-sm leading-[16px] sm:leading-[24px] max-h-[105px] overflow-hidden absolute bottom-4 lg:-bottom-[100%] left-0 px-2 sm:py-2 py-2 lg:group-hover:bottom-4 transition-all duration-500 ease-linear"><?php the_excerpt(); ?></div>
                            </div>
                        </a>
                    </div>
                <?php endwhile; ?>
            </ul>
        </div>
    </section>

    <?php get_template_part( 'inc/pagination', null, array( 'services' => $query ) ); ?>

<?php get_footer(); ?>