<?php
$crumbs = explode("/", $_SERVER["REQUEST_URI"]);
?>
<section class="flex">
    <nav aria-label="breadcrumb" class="w-full p-4 dark:bg-gray-800 dark:text-gray-100">
            <ol class="flex justify-center items-center h-8 sm:space-x-2 text-xs dark:text-gray-100 sm:text-base">
                <?php foreach ($crumbs as $key => $crumb) :  ?>
                    <li class="flex items-center">
                        <?php if ($key === 1) : ?>
                            <a href="/" class="flex items-center hover:underline">
                                <?php echo 'Home'; ?>
                            </a>
                        <?php endif; ?>
                        <?php if ($key === 2) :  ?>
                            <span class="dark:text-gray-400">/</span>
                            <a href="/<?php echo $crumbs[1]; ?>" class="flex items-center px-1 capitalize hover:underline">
                                <?php echo  str_replace('-', ' ', $crumbs[1]) ; ?>
                            </a>
                        <?php endif; ?>
                        <?php if ($key === 3) : ?>
                            <span class="dark:text-gray-400">/</span>
                            <p class="flex items-center px-1 capitalize hover:no-underline cursor-default">
                                <?php echo  str_replace('-', ' ', $crumbs[2]);  ?>
                            </p>
                        <?php endif; ?>
                    </li>
                <?php endforeach; ?>
            </ol>
    </nav>
</section>

