<?php extract($args); ?>
<section class="mx-auto max-w-[69rem]" id="map">
    <div class="flex flex-col-reverse py-14 lg:flex-row">
        <div class="flex flex-col px-6 py-8 space-y-6 bg-gray-100 text-mtkn-dark rounded-xl w-[95%] mx-auto sm:p-8 lg:w-1/2 lg:p-12 xl:w-2/5">
            <div class="flex space-x-2 sm:space-x-4">
                <svg stroke-width="1.5"  viewBox="0 0 24 24" class="flex-shrink-0 w-6 h-6" fill="none" xmlns="http://www.w3.org/2000/svg" color="#000000"><path d="M9 19l-5.21 1.737a.6.6 0 01-.79-.57V5.433a.6.6 0 01.41-.569L9 3m0 16l6 2m-6-2V3m6 18l5.59-1.863a.6.6 0 00.41-.57V3.832a.6.6 0 00-.79-.569L15 5m0 16V5m0 0L9 3" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                <div class="space-y-2">
                    <p class="sm:text-lg font-medium leading-snug">Address</p>
                    <div class="flex space-x-2">
                        <span class="font-medium">MM:</span>
                        <p class="text-sm sm:text-base leading-snug"><?= $home['myanmar_address']; ?></p>
                    </div>
                    <div class="flex space-x-4">
                        <span class="font-medium">TH:</span>
                        <p class="text-sm sm:text-base leading-snug"><?= $home['thailand_address']; ?></p>
                    </div>
                </div>
            </div>
            <div class="flex space-x-2 sm:space-x-4">
                <svg stroke-width="1.5" viewBox="0 0 24 24" class="flex-shrink-0 w-6 h-6" fill="none" xmlns="http://www.w3.org/2000/svg" color="#000000"><path d="M7 9l5 3.5L17 9" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2 17V7a2 2 0 012-2h16a2 2 0 012 2v10a2 2 0 01-2 2H4a2 2 0 01-2-2z" stroke="#000000" stroke-width="1.5"></path></svg>
                <div class="space-y-2">
                    <p class="sm:text-lg font-medium leading-snug">Email Us</p>
                    <a href='mailto:"<?= $home['email']; ?>"' class="text-sm sm:text-base leading-snug"><?= $home['email']; ?></a>
                </div>
            </div>
            <div class="flex space-x-2 sm:space-x-4">
                <svg stroke-width="1.5" viewBox="0 0 24 24" class="flex-shrink-0 w-6 h-6" fill="none" xmlns="http://www.w3.org/2000/svg" color="#000000"><path d="M18.118 14.702L14 15.5c-2.782-1.396-4.5-3-5.5-5.5l.77-4.13L7.815 2H4.064c-1.128 0-2.016.932-1.847 2.047.42 2.783 1.66 7.83 5.283 11.453 3.805 3.805 9.286 5.456 12.302 6.113 1.165.253 2.198-.655 2.198-1.848v-3.584l-3.882-1.479z" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                <div class="space-y-2">
                    <p class="sm:text-lg font-medium leading-snug">Call Us</p>
                    <a href='tel:"<?= $home['phone']; ?>"' class="text-sm sm:text-base leading-snug"><?= $home['phone']; ?></a>
                </div>
            </div>
        </div>
        <div class="lg:w-1/2 xl:w-3/5">
            <div class="flex items-center justify-center p-4 md:p-8 lg:p-4">
                <div class="w-full" x-data="{ activeTab: 'myanmar' }">
                    <ul class="flex border-2 border-gray-200 text-center">
                        <li class="flex-1">
                            <a @click.prevent="activeTab = 'myanmar'" :class="{ 'button-active !bg-mtkn-blue text-white': activeTab === 'myanmar' }" href="#" class="button
                            relative block bg-white p-4 text-sm text-mtkn-blue font-medium">
                                Myanmar
                            </a>
                        </li>

                        <li class="flex-1">
                            <a @click.prevent="activeTab = 'thailand'" :class="{ 'button-active !bg-mtkn-blue text-white': activeTab === 'thailand' }" href="#" class="button
                            relative block bg-white p-4 text-sm text-mtkn-blue font-medium">
                                Thailand
                            </a>
                        </li>
                    </ul>

                    <div class="content mt-3">
                        <div x-cloak x-show="activeTab === 'myanmar'">
                            <iframe class="rounded-xl shadow-lg w-full h-[25rem] sm:min-h-96 aspect-video"  src="<?= $home['myanmar_map']; ?>"  style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                        </div>
                        <div x-cloak x-show="activeTab === 'thailand'">
                            <iframe class="rounded-xl shadow-lg w-full h-[25rem] sm:min-h-96 aspect-video"  src="<?= $home['thailand_map']; ?>"  style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
