<?php
extract($args);
$big = 999999999;
$current_page = max(1, get_query_var('paged'));
if (isset($services->max_num_pages)) {
    $pages = paginate_links(array(
        'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
        'format' => '?page=%#%',
        'current' => $current_page,
        'total' => $services->max_num_pages,
        'type' => 'array',
        'show_all' => true,
    ));
} else {
    global $wp_query;
    $pages = paginate_links(array(
        'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
        'format' => '?page=%#%',
        'current' => $current_page,
        'total' => $total_pages,
        'type' => 'array',
        'show_all' => true,
    ));
}
if (isset($services->max_num_pages)) {
    $total_pages = $services->max_num_pages;
}
function previous_paginate($total_pages)
{
    echo previous_posts_link('<button class="bg-mtkn-blue text-white  border-gray-100 py-2 hover:bg-mtkn-yellow px-3 mr-1"><div class="flex flex-row align-middle"><p class="ml-2">«  Prev</p></div></button>', $total_pages);
}

function next_paginate($total_pages)
{
    echo next_posts_link('<button class="bg-mtkn-blue text-white py-2 border-gray-200 hover:bg-mtkn-yellow px-3"><div class="flex flex-row align-middle"><p class="mr-2">Next  »</p></div> </button>', $total_pages);
} ?>
<div class="flex max-w-[90rem] items-center justify-center mx-auto border-t border-gray-200 bg-white px-4 py-3 sm:px-6">
    <div class="sm:flex sm:flex-1 sm:items-center sm:justify-center">
        <div>
            <?php
            if (is_array($pages)) {
                if ($total_pages > 10) {
                    echo '<div class="max-w-[69rem] py-2 mt-4 text-sm"><div class="flex flex-row mx-auto">';
                    previous_paginate($total_pages);
                    next_paginate($total_pages);
                    echo '</div></div>';
                } else {
                    /* hide on medium  */
                    echo '<div class="hidden max-w-[69rem] py-2 mt-4 text-sm pagination-wrap md:block"><ul class="pagination">';
                    foreach ($pages as $page) {
                        echo "<li>$page</li>";
                    }
                    echo '</ul></div>';
                    /* hide on desktop */
                    echo '<div class="block max-w-[69rem] py-2 mt-4 text-sm md:hidden"><div class="flex flex-row mx-auto">';
                    previous_paginate($total_pages);
                    next_paginate($total_pages);
                    echo '</div></div>';
                }
            }
            ?>
        </div>
    </div>
</div>
