<?php get_header(); ?>
    <section class="body-font mx-auto max-w-[69rem]">
        <div class="container px-5 mx-auto py-14">
            <div id="content" class="flex flex-wrap justify-center -m-4">
                <?php if (have_posts()) : while (have_posts()) : the_post();
                    if (isset($_GET['post_type'])) : $type = $_GET['post_type'];
                        if ($type == 'product') : ?>
                            <div class="p-4 lg:w-1/3">
                                <a href="<?php the_permalink(); ?>" class="relative block group h-[30rem]">
                                    <img alt="Developer" src="<?php the_post_thumbnail_url(); ?>"
                                         class="absolute inset-0 object-cover w-full h-full transition-opacity rounded-xl group-hover:opacity-50 "/>
                                    <div class="relative p-4 sm:p-6 lg:p-8">
                                        <p class="text-sm font-medium tracking-widest uppercase text-mtkn-yellow">
                                            Products
                                        </p>
                                        <p class="text-xl font-bold text-white sm:text-2xl"><?php the_title(); ?></p>
                                        <div class="mt-32 sm:mt-48 lg:mt-64">
                                            <div class="transition-all transform translate-y-8 opacity-0 sm:group-hover:translate-y-0 sm:group-hover:opacity-100">
                                                <div class=""><?php the_excerpt(); ?></div>
                                            </div>
                                        </div>
                                        <div class="block text-white font-medium mt-[10rem] sm:hidden"><?php the_excerpt(); ?></div>
                                    </div>
                                </a>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                 <?php endwhile; ?>
                    <div class="mt-5 w-full flex  justify-center items-center gap-2 sm:gap-3">
                        <a href="<?php echo esc_url(home_url('/products')); ?>"
                           class="inline-block px-8 py-3 text-sm font-medium text-white transition rounded bg-mtkn-blue hover:scale-110 hover:shadow-xl">
                            All Products
                        </a>
                    </div>
                <?php else : ?>
                    <div class="text-center py-10 px-4 sm:px-6 lg:px-8">
                        <h1 class="block text-2xl font-bold text-white"></h1>
                        <p class="text-gray-600 dark:text-gray-400">Sorry, we couldn't find the product you search.</p>
                        <div class="mt-5 flex flex-col justify-center items-center gap-2 sm:flex-row sm:gap-3">
                            <a href="<?php echo esc_url(home_url('/')); ?>"
                               class="inline-block px-8 py-3 text-sm font-medium text-white transition rounded bg-mtkn-blue hover:scale-110 hover:shadow-xl">
                                Back To Home
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php get_footer(); ?>