<?php
get_header();
$content = get_queried_object();
$query = new WP_Query(array(
    'posts_per_page' => -1,
    'post_type' => 'product',
    'tax_query' => array(
        array(
            'taxonomy' => $content->taxonomy,
            'field' => $content->name,
            'terms' => $content->term_id,
        )
    )
));
$featured_img = get_field('image', $content->taxonomy . '_' . $content->term_id);
?>
    <!-- banner -->
<?php get_template_part('template-parts/section-banner', null, array('content' => $content)); ?>

    <!-- products -->
    <section>
        <div class="max-w-screen-xl px-4 py-8 mx-auto sm:px-6 sm:py-12 lg:px-8">
            <header class="text-center">
                <h2 class="text-xl font-bold text-gray-900 sm:text-3xl">
                    <?= $content->name; ?> Collection
                </h2>

                <p class="max-w-md mx-auto mt-4 text-gray-500">
                    <?php
                    if (get_field('short_description', $content->taxonomy . '_' . $content->term_id)) {
                        get_field('short_description', $content->taxonomy . '_' . $content->term_id);
                    } else {
                        echo $content->description;
                    }
                    ?>
                </p>
            </header>

            <ul class="grid gap-4 mt-8 sm:grid-cols-2 lg:grid-cols-4">
                <?php while ($query->have_posts()) : $query->the_post(); ?>
                    <li>
                        <a href="<?= get_permalink(); ?>" class="block overflow-hidden group">
                            <img src="<?= get_the_post_thumbnail_url(); ?>" alt=""
                                 class="h-[350px] w-full object-cover transition duration-500 group-hover:scale-105 sm:h-[450px]"/>

                            <div class="relative pt-3 bg-white">
                                <h3 class="text-xs text-gray-700 group-hover:underline group-hover:underline-offset-4"><?= the_title(); ?></h3>
                                <p class="mt-2">
                                    <span class="sr-only"> Regular Price </span>
                                    <span class="tracking-wider text-gray-900"> £24.00 </span>
                                </p>
                            </div>
                        </a>
                    </li>
                <?php endwhile; ?>
            </ul>
        </div>
    </section>

<?php get_footer(); ?>