<?php extract($args); ?>
<?php if (is_page_template()) : ?>
    <section class="relative">
        <div style="background-image:url(<?= get_the_post_thumbnail_url(); ?>);"
             class="overflow-hidden bg-center bg-no-repeat bg-cover">
            <div class="p-20 md:p-20 lg:px-16 lg:py-24">
                <div class="max-w-6xl mx-auto mt-20 text-center 2xl:max-w-7xl sm:mt-32">
                    <h2 class="text-3xl font-bold tracking-wide text-white uppercase hero-content font-poppins md:text-4xl lg:text-5xl"><?= the_title(); ?></h2>
                    <div class="hidden text-sm text-white/90 md:mt-4 md:text-base lg:text-lg md:leading-relaxed md:block"><?= get_the_excerpt(); ?></div>
                </div>
            </div>
        </div>
    </section>
<?php elseif (is_single() || is_archive()) : ?>
    <section class="relative">
        <div style="background-image:url(https://images.unsplash.com/photo-1606857521015-7f9fcf423740?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=1470&q=80);"
             class="pt-16 overflow-hidden bg-center bg-no-repeat bg-cover">
            <div class="p-20 md:p-20 lg:px-16 lg:py-24">
            </div>
        </div>
    </section>
<?php elseif (is_tax()) :
    $featured_img = get_field('image', $content->taxonomy . '_' . $content->term_id);
    ?>
    <section style="background-image:url(<?php echo $featured_img['url']; ?>);"
             class="relative bg-center bg-no-repeat bg-cover max-h-[50rem]">
        <div class="absolute inset-0 bg-black/10"></div>
        <div class="relative max-w-screen-xl px-4 py-32 mx-auto sm:px-6 lg:flex lg:h-screen lg:items-center lg:px-8 lg:pb-[21rem]">
            <div class="max-w-xl text-center sm:text-left">
                <h1 class="text-3xl font-extrabold sm:text-5xl">
                    <strong class="block font-extrabold">
                        <?= $content->name; ?>
                    </strong>
                </h1>
                <p class="max-w-lg mt-4 sm:text-xl sm:leading-relaxed"><?= $content->description; ?></p>
                <div class="flex flex-wrap gap-4 mt-8 text-center">
                    <a href="#"
                       class="inline-block px-8 py-3 text-sm font-medium text-white transition rounded bg-mtkn-blue hover:scale-110 hover:shadow-xl">Shop
                        Now</a>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>