<?php
$id = THAI_CONTACT_US_PAGE;
$post = get_post($id);
$contact = get_post_field('post_content', $id);
?>
<section class="max-w-[69rem] mx-auto">
    <div class="max-w-screen-xl px-4 py-16 mx-auto sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 gap-x-16 gap-y-8 lg:grid-cols-5">
            <div class="lg:col-span-2 lg:pb-12">
                <h1 class="mb-4 text-3xl font-medium text-gray-900 title-font sm:text-4xl">Get In Touch</h1>
                <div class="max-w-xl text-lg"><?= $contact; ?></div>
            </div>

            <div class="p-8 bg-white rounded-lg shadow-lg lg:col-span-3 lg:p-12">
                <form id="contact_form" class="space-y-4 ajax">
                    <div>
                        <label class="sr-only" for="name">Name</label>
                        <input class="w-full p-3 text-sm border-gray-200 rounded-lg" placeholder="Name" type="text" name="name" id="name" />
                        <span id="error_name" class="text-sm text-rose-500"></span>
                    </div>

                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <div>
                            <label class="sr-only" for="email">Email</label>
                            <input class="w-full p-3 text-sm border-gray-200 rounded-lg" placeholder="Email address" type="email" name="email" id="email" />
                            <span id="error_email" class="text-sm text-rose-500"></span>
                        </div>

                        <div>
                            <label class="sr-only" for="subject">Subject</label>
                            <input class="w-full p-3 text-sm border-gray-200 rounded-lg" placeholder="Subject" type="text" name="subject" id="subject" />
                            <span id="error_subject" class="text-sm text-rose-500"></span>
                        </div>
                    </div>

                    <div>
                        <label class="sr-only" for="message">Message</label>

                        <textarea class="w-full p-3 text-sm border-gray-200 rounded-lg" placeholder="Message" rows="8" name="message" id="message"></textarea>
                        <span id="error_message" class="text-sm text-rose-500"></span>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="inline-block w-full px-5 py-3 font-medium text-white transition rounded-lg bg-mtkn-blue hover:bg-mtkn-yellow hover:text-mtkn-blue sm:w-auto">
                            Send Enquiry
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>