<?php
$id = $post->ID;
$taxonomy_name = get_post_taxonomies($id)[2];
$custom_terms = wp_get_post_terms($post->ID, $taxonomy_name);
$tax_query = array();
$tax_query['relation'] = 'OR';
foreach ($custom_terms as $custom_term) {
    $tax_query[] = array(
        'taxonomy' => $taxonomy_name,
        'field' => 'slug',
        'terms' => $custom_term->slug,
    );
}
$args = array(
    'post_type' => THAI_PRODUCT_POST_TYPE,
    'posts_per_page' => 4,
    'tax_query' => $tax_query,
    'orderby' => 'rand',
    'post__not_in' => array($post->ID),
);
$products = new WP_Query($args);
if ($products->have_posts()) :
?>
<section class="body-font mx-auto max-w-[69rem]">
    <h1 class="text-3xl text-center font-medium border-t-2 border-mtkn-dark pt-3">Related Products</h1>
    <div class="container px-5 mx-auto py-14">
        <div class="flex flex-wrap -m-4">
            <?php while ($products->have_posts()) : $products->the_post(); ?>
                <div class="p-4 lg:w-1/3">
                    <a href="<?php the_permalink(); ?>" class="relative block group h-[30rem]">
                        <img alt="Developer" src="<?php the_post_thumbnail_url(); ?>"
                             class="absolute inset-0 object-cover w-full h-full transition-opacity rounded-xl group-hover:opacity-50 "/>
                        <div class="relative p-4 sm:p-6 lg:p-8">
                            <p class="text-sm font-medium tracking-widest uppercase text-mtkn-yellow">
                                Products
                            </p>
                            <p class="text-xl font-bold text-white sm:text-2xl"><?php the_title(); ?></p>
                            <div class="mt-32 sm:mt-48 lg:mt-64">
                                <div class="transition-all transform translate-y-8 opacity-0 sm:group-hover:translate-y-0 sm:group-hover:opacity-100">
                                    <div class=""><?php the_excerpt(); ?></div>
                                </div>
                            </div>
                            <div class="block text-white font-medium mt-[10rem] sm:hidden"><?php the_excerpt(); ?></div>
                        </div>
                    </a>
                </div>
            <?php endwhile; wp_reset_query(); endif; ?>
        </div>
    </div>
</section>