<?php extract($args); ?>
<section id="hero-slider" class="relative h-auto" x-data="{ showModal: false }" x-on:keydown.window.escape="showModal = false">
    <div class="swiper hero-swiper">
        <div class="swiper-wrapper">
            <?php
            foreach ($sliders as $key => $slide) :
                $featured_img = wp_get_attachment_url(get_post_thumbnail_id($slide->ID));
            ?>
                <div class="overflow-hidden bg-center bg-no-repeat bg-cover h-[55%] swiper-slide cursor-grab md:h-[63%] lg:h-[70%] xl:h-full " style="background-image:url(<?php echo $featured_img; ?>);">
                    <div class="h-full">
                        <section class="container mx-auto">
                            <div class="my-auto flex h-[30rem] xl:h-[45rem] items-center justify-between">
                                <div class="flex-row items-center justify-center lg:w-[83%] 2xl:w-[69%] mx-auto sm:flex sm:justify-between">
                                    <div class="text-center sm:w-3/4 sm:text-left">
                                        <h1 class="text-xl tracking-wide uppercase sm:text-2xl md:text-4xl lg:text-5xl xl:text-6xl">
                                            <?= $slide->post_title; ?></h1>
                                        <h3 class="my-3 text-sm font-light md:text-lg"><?= $slide->post_content; ?></h3>
                                        <a href="<?= $slide->service_link; ?>" class="inline-block px-8 py-3 text-sm font-medium text-white transition rounded bg-mtkn-blue hover:bg-mtkn-yellow hover:text-mtkn-blue hover:shadow-xl">Learn More</a>
                                    </div>
                                    <div class="flex justify-center mt-5 sm:mt-0" id="target">
                                        <button class="w-12 transition sm:w-20 ripple hover:scale-110 modalButton" x-on:click="showModal = !showModal" id="<?= $slide->ID; ?>">
                                            <svg id="playButton" width="45px" height="30px" style="enable-background:new 0 0 512 512;" version="1.1" fill="white" viewBox="0 0 512 512" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                                                <path d="M405.2,232.9L126.8,67.2c-3.4-2-6.9-3.2-10.9-3.2c-10.9,0-19.8,9-19.8,20H96v344h0.1c0,11,8.9,20,19.8,20  c4.1,0,7.5-1.4,11.2-3.4l278.1-165.5c6.6-5.5,10.8-13.8,10.8-23.1C416,246.7,411.8,238.5,405.2,232.9z" />
                                            </svg>
                                        </button>
                                        <div x-cloak x-show="showModal" x-transition.opacity class="fixed inset-0 bg-slate-900/75"></div>
                                        <div x-cloak x-show="showModal" x-transition class="fixed inset-0 z-50 flex items-center justify-center swiper-no-swiping">
                                            <div x-on:scroll.window="showModal = false;" class="w-screen max-w-xl mx-auto rounded-lg h-fit">
                                                <div x-on:click="showModal = false;" class="w-12 h-12 bg-red-500 flex items-center justify-center mb-1 ml-auto cursor-pointer hover:bg-red-300 close">
                                                    <svg class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                                    </svg>
                                                </div>
                                                <?= $slide->youtube_link; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                    </div>
                </div>
            <?php
            endforeach;
            ?>
        </div>
    </div>
    <!-- If we need pagination -->
    <div class="hidden swiper-pagination hero-swiper-pagination rounded-xl xl:block"></div>
    <div class="text-mtkn-yellow hero-swiper-button swiper-button-prev xl:invisible"></div>
    <div class="text-mtkn-yellow hero-swiper-button swiper-button-next xl:invisible"></div>
    <div x-cloak x-show="showModal" x-transition.opacity class="fixed inset-0 bg-slate-900/75"></div>
</section>

<script>
    jQuery(document).ready(function($){
        const players = Array.from(document.querySelectorAll('.video'));
        players.forEach(function(player) {
            player = new Plyr(player, {
                //debug:true,
                autoplay: false,
                ratio: '16:9',
            })
            let test = jQuery(player).attr('class');
            let container = jQuery(player.media).parents('.video_container');
            let image = container.attr('data-plyr-poster');

            window.addEventListener("load", function() {
                setTimeout(() => {
                    container.css({opacity:1});
                }, 1000);
            })
            jQuery(".close").on("click", function () {
                player.stop();
            });
            $(document).keyup(function(e) {
                if (e.key === "Escape" ) {
                   player.stop();
                }
            });
            $(document).on( "scroll", function() {
               player.stop()
            } );
        });
    });
</script>