<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'total_price', 'payment_slip'];

    protected function products()
    {
        return $this->hasMany(Product::class);
    }

    protected function user()
    {
        return $this->belongsTo(User::class);
    }
}
