<?php

namespace App\Livewire\Backend\User;

use App\Models\Role;
use App\Models\User;
use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Attributes\Title;
use Livewire\Attributes\Validate;
use Livewire\Component;

class CreateUser extends Component
{
    #[Title('Create User')]
    #[Layout('layouts.admin')]

    public $name;
    public $email;
    public $password;
    public $password_confirmation;

    #[Validate('array')]
    public $selectedRoles = [];
    public $roles;

    public function mount()
    {
        $this->refreshRoles();
        $this->selectedRoles = [];
    }

    #[On('roleAdded')]
    public function refreshRoles()
    {
        $this->roles = Role::all(['id', 'name']);
        $newRole = $this->roles->last();
        if (!in_array($newRole->id, $this->selectedRoles)) {
            $this->selectedRoles[] = $newRole->id;
        }
    }

    public function save()
    {
        // Validate the data
        $validated = $this->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|min:8|confirmed'
        ]);

        // Create the user
        $user = User::create($validated);

        $user->roles()->attach($this->selectedRoles);
        $this->reset();
        session()->flash('message', 'User created successfully!');
        return $this->redirect(route('admin-users'), navigate: true);
    }

    public function render()
    {
        return view('livewire.backend.user.create-user');
    }
}
