<?php

namespace App\Livewire\Frontend;

use App\Models\User;
use Illuminate\Support\Facades\Cache;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Session;
use Livewire\Attributes\Url;
use Livewire\Component;
use Livewire\WithPagination;

class Home extends Component
{

    use WithPagination;

    #[Url(history: true, as: 's')]
    public $search;

    public function render()
    {
        $users = $this->search == ''
        ? Cache::remember('users_paginated', 60, fn() => User::with('articles')->paginate(10))
        : User::where('name', 'like', '%'.$this->search.'%')->with('articles')->paginate(10);
    
        return view('livewire.frontend.home', [
            'users' => $users
        ]);
    }
}
