<?php 
$fields = get_fields(KH_HOME_PAGE);
?>

<footer class="fluid bg-[#636363] text-white">
    <div class="kh_container py-4 lg:py-8">
        <div class="grid grid-cols-2 lg:grid-cols-4 gap-2 sm:gap-4 lg:gap-8">
            <div class="flex items-center">
                <a href="/"><img class="w-20 sm:w-24 lg:w-32" src="<?= $fields['logo'] ;?>" alt="logo"></a>
            </div>
            <div class="block lg:hidden mb-4">
                <h6 class="mb-2 sm:mb-4 lg:mb-8 text-sm lg:text-base">Follow Us</h6>
                <div class="flex gap-4">
                    <div>
                        <i class="fa-brands fa-linkedin text-base xl:text-xl hover:text-blue-400"></i>
                    </div>
                    <div>
                        <i class="fa-brands fa-facebook text-base xl:text-xl hover:text-blue-700"></i>
                    </div>
                    <div>
                        <i class="fa-brands fa-instagram text-base xl:text-xl hover:text-orange-500"></i>
                    </div>
                    <div>
                        <i class="fa-brands fa-youtube text-base xl:text-xl hover:text-red-600"></i>
                    </div>
                </div>
            </div>
            <div class="px-4">
                    <?php 
                        wp_nav_menu([
                            'theme_location' => 'footer',
                            'menu_class' => 'footer_menu space-y-2 lg:space-y-4 py-4'
                        ])
                    ;?>
            </div>
            <div>
                <div class="text-center mb-4 lg:mb-8 hidden lg:block">
                    <i class="fa-solid fa-location-dot text-lg sm:text-xl lg:text-3xl text-kh_primary"></i>
                    <p class="text-[12px] sm:text-sm lg:text-base lg:px-2 text-justify"><a href="https://maps.app.goo.gl/RM5goy3C8EVRCsvHA"><?= $fields['address'] ;?></a></p>
                </div>
                <div class="my-4 block lg:hidden">
                    <div class="flex gap-4 items-center mb-4">
                        <svg class="w-5 fill-white" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M215.7 499.2C267 435 384 279.4 384 192C384 86 298 0 192 0S0 86 0 192c0 87.4 117 243 168.3 307.2c12.3 15.3 35.1 15.3 47.4 0zM192 128a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"/></svg>
                        <p class="text-[12px] sm:text-sm lg:text-base lg:px-2 text-justify w-full">
                            <a href="https://maps.app.goo.gl/RM5goy3C8EVRCsvHA" target="_blank"><?= $fields['address'] ;?></a>
                        </p>
                    </div>
                    <div class="flex gap-4 items-center mb-4">
                        <svg class="w-4 fill-white" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M48 64C21.5 64 0 85.5 0 112c0 15.1 7.1 29.3 19.2 38.4L236.8 313.6c11.4 8.5 27 8.5 38.4 0L492.8 150.4c12.1-9.1 19.2-23.3 19.2-38.4c0-26.5-21.5-48-48-48L48 64zM0 176L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-208L294.4 339.2c-22.8 17.1-54 17.1-76.8 0L0 176z"/></svg>
                        <p class="text-[12px] sm:text-sm lg:text-base lg:px-2 text-justify break-all">
                            <a href="mailto:<?= $fields['email'] ;?>"><?= $fields['email'] ;?></a>
                        </p>
                    </div>
                    <div class="flex gap-4 items-center mb-4">
                        <svg class="w-4 fill-white" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M164.9 24.6c-7.7-18.6-28-28.5-47.4-23.2l-88 24C12.1 30.2 0 46 0 64C0 311.4 200.6 512 448 512c18 0 33.8-12.1 38.6-29.5l24-88c5.3-19.4-4.6-39.7-23.2-47.4l-96-40c-16.3-6.8-35.2-2.1-46.3 11.6L304.7 368C234.3 334.7 177.3 277.7 144 207.3L193.3 167c13.7-11.2 18.4-30 11.6-46.3l-40-96z"/></svg>
                        <p class="text-[12px] sm:text-sm lg:text-base lg:px-2 text-justify"><a href="tel:+<?= $fields['phone'] ;?>"><?= $fields['phone'] ;?></a></p>
                    </div>
                </div>
            </div>
            <div class="text-center hidden lg:block">
                <h6 class="mb-4 lg:mb-8">Follow Us</h6>
                <div class="flex justify-center gap-4">
                    <div>
                        <svg class="w-4 xl:w-5 fill-white hover:fill-blue-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M416 32H31.9C14.3 32 0 46.5 0 64.3v383.4C0 465.5 14.3 480 31.9 480H416c17.6 0 32-14.5 32-32.3V64.3c0-17.8-14.4-32.3-32-32.3zM135.4 416H69V202.2h66.5V416zm-33.2-243c-21.3 0-38.5-17.3-38.5-38.5S80.9 96 102.2 96c21.2 0 38.5 17.3 38.5 38.5 0 21.3-17.2 38.5-38.5 38.5zm282.1 243h-66.4V312c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9V416h-66.4V202.2h63.7v29.2h.9c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9V416z"/></svg>
                    </div>
                    <div>
                        <svg class="w-4 xl:w-5 fill-white hover:fill-blue-700" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64h98.2V334.2H109.4V256h52.8V222.3c0-87.1 39.4-127.5 125-127.5c16.2 0 44.2 3.2 55.7 6.4V172c-6-.6-16.5-1-29.6-1c-42 0-58.2 15.9-58.2 57.2V256h83.6l-14.4 78.2H255V480H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64z"/></svg>
                    </div>
                    <div>
                        <svg class="w-4 xl:w-5 fill-white hover:fill-orange-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"/></svg>
                    </div>
                    <div>
                        <svg class="w-4 xl:w-6 fill-white hover:fill-red-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M549.7 124.1c-6.3-23.7-24.8-42.3-48.3-48.6C458.8 64 288 64 288 64S117.2 64 74.6 75.5c-23.5 6.3-42 24.9-48.3 48.6-11.4 42.9-11.4 132.3-11.4 132.3s0 89.4 11.4 132.3c6.3 23.7 24.8 41.5 48.3 47.8C117.2 448 288 448 288 448s170.8 0 213.4-11.5c23.5-6.3 42-24.2 48.3-47.8 11.4-42.9 11.4-132.3 11.4-132.3s0-89.4-11.4-132.3zm-317.5 213.5V175.2l142.7 81.2-142.7 81.2z"/></svg>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div>
        <p class="text-center py-2 text-xs sm:text-sm lg:text-base border-t border-slate-600">Copyright &copy; By <a href="/">MTKN-Cambodia Trading Co.,Ltd</a></p>
    </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.3/dist/cdn.min.js" loading="lazy"></script>
<script defer src="https://cdn.jsdelivr.net/npm/@alpinejs/focus@3.x.x/dist/cdn.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        function updateHeaderHeight() {
            const headerHeight = document.getElementById('main-header').offsetHeight;
            document.documentElement.style.setProperty('--header-height--', `${headerHeight}px`);
        }
        updateHeaderHeight();
        window.addEventListener('resize', updateHeaderHeight);
    });

    document.addEventListener('alpine:init', () => {
        Alpine.data('productData', () => ({
            // Quotation Form
            selectedItem: JSON.parse(localStorage.getItem('selectedItem')) || [],
            formData: {
                name: '',
                email: '',
                phone: '',
                organization: '',
                message: '',
                qty: 1
            },
            errors: {},
            successMessage: '',
            errorMessage: '',

            validateForm() {
                this.errors = {};
                if(!this.formData.name) {
                    this.errors.name = "Name is required";
                }
                if (!this.formData.email) {
                this.errors.email = 'Email is required.';
                }
                if(!this.formData.phone) {
                    this.errors.phone = "Phone number is required";
                }
                if(!this.formData.organization) {
                    this.errors.organization = "Organization is required";
                }
                if(!this.formData.message) {
                    this.errors.message = "Message is required";
                }
                if(this.formData.qty <= 0 ) {
                    this.errors.qty = "Quantity must be at least 1";
                }
                if(this.selectedItem.length <= 0) {
                    this.errors.products = "You need to select one product at least."
                }

                return Object.keys(this.errors).length === 0;
            },
            validateEmail(email) {
                const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                return re.test(email);
            },
            submitForm() {
                if(this.validateForm()) {
                    fetch('<?php echo admin_url('admin-ajax.php'); ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
                        },
                        body: new URLSearchParams({
                            action: 'submit_quotation_form',
                            nonce: '<?php echo wp_create_nonce('my_nonce'); ?>',
                            selectedItem: JSON.stringify(this.selectedItem),
                            formData: JSON.stringify(this.formData)
                        })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            this.successMessage = "Form has been successfully submitted";
                            this.selectedItem = [];
                            this.formData.name = '';
                            this.formData.email = '';
                            this.formData.phone = '';
                            this.formData.organization = '';
                            this.formData.message = '';
                            this.formData.qty = 1;
                            localStorage.removeItem('selectedItem');
                            setTimeout(() => {
                                this.successMessage = '';
                            }, 5000);
                        } else {
                            this.errorMessage = 'Error: ' + data.data;
                            this.successMessage = '';
                        }
                    });
                }
            },
            
            // Contact Form
            contact_form: {
                first_name: '',
                last_name: '',
                email: '',
                phone: '',
                subject: '',
                message: ''
            },
            contact_errors: {},
            contact_successMessage: '',
            contact_errorMessage: '',

            contact_validateForm() {
                this.contact_errors = {};
                if(!this.contact_form.first_name) {
                    this.contact_errors.first_name = "Firstname is required";
                }
                if(!this.contact_form.last_name) {
                    this.contact_errors.last_name = "Lastname is required";
                }
                if(!this.contact_form.email) {
                    this.contact_errors.email = "Email is required";
                }
                if(!this.contact_form.phone) {
                    this.contact_errors.phone = "Phone is required";
                }
                if(!this.contact_form.subject) {
                    this.contact_errors.subject = "Subject is required";
                }
                if(!this.contact_form.message) {
                    this.contact_errors.message = "Message is required";
                }

                return Object.keys(this.contact_errors).length === 0;
            },

            contact_form_submit() {
                if(this.contact_validateForm()) {
                    fetch('<?php echo admin_url('admin-ajax.php'); ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
                        },
                        body: new URLSearchParams({
                            action: 'submit_contact_form',
                            nonce: '<?php echo wp_create_nonce('my_nonce') ;?>',
                            contactForm: JSON.stringify(this.contact_form)
                        })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if(data.success) {
                            this.contact_successMessage = "Form has been successfully submitted.";
                            this.contact_form.first_name = '';
                            this.contact_form.last_name = '';
                            this.contact_form.email = '';
                            this.contact_form.phone = '';
                            this.contact_form.subject = '';
                            this.contact_form.message = '';
                            setTimeout(() => {
                                this.contact_successMessage = '';
                            }, 5000);
                        } else {
                            this.errorMessage = 'Error: ' + data.data;
                            this.successMessage = '';
                        }
                    })
                }
            },



            get total() {
                return this.selectedItem.length;
            },
            toggle(post) {
                if (this.selectedItem.some(item => item.id === post.id)) {
                    this.selectedItem = this.selectedItem.filter(item => item.id !== post.id);
                } else {
                    this.selectedItem.push(post);
                }
                localStorage.setItem('selectedItem', JSON.stringify(this.selectedItem));
            },
        }));
    });
</script>
</body>
</html>