<h2 class="text-center text-2xl font-bold mb-4">Contact Form</h2>
<div>
    <form @submit.prevent="contact_form_submit">
        <div class="grid grid-cols-2 gap-2 lg:gap-4">
            <div class="mb-4">
                <label class="form-lable" for="first_name">First Name</label>
                <input id="first_name" class="form-input" type="text" placeholder="First Name" x-model="contact_form.first_name" required>
                <span x-show="contact_errors.first_name" x-text="contact_errors.first_name" class="text-red-600 text-xs sm:text-sm lg:text-base"></span>
            </div>
            <div class="mb-4">
                <label class="form-lable" for="last_name">Last Name</label>
                <input id="last_name" class="form-input" type="text" placeholder="Last Name" x-model="contact_form.last_name" required>
                <span x-show="contact_errors.last_name" x-text="contact_errors.last_name" class="text-red-600 text-xs sm:text-sm lg:text-base"></span>
            </div>
        </div>
        <div class="grid grid-cols-2 gap-2 sm:gap-4">
            <div class="mb-4">
                <label class="form-lable" for="email">Email</label>
                <input id="email" class="form-input" type="email" placeholder="Your Email" x-model="contact_form.email" required>
                <span x-show="contact_errors.email" x-text="contact_errors.email" class="text-red-600 text-xs sm:text-sm lg:text-base"></span>
            </div>
            <div class="mb-4">
                <label class="form-lable" for="phone">Phone</label>
                <input id="phone" class="form-input" type="tel" placeholder="+959123456789" x-model="contact_form.phone" pattern="^\+?[0-9]+$" required>
                <span x-show="contact_errors.phone" x-text="contact_errors.phone" class="text-red-600 text-xs sm:text-sm lg:text-base"></span>
            </div>
        </div>
        <div class="mb-4">
            <label class="form-lable" for="subject">Subject</label>
            <input id="subject" class="form-input" type="text" placeholder="Subject..." x-model="contact_form.subject" required>
            <span x-show="contact_errors.subject" x-text="contact_errors.subject" class="text-red-600 text-xs sm:text-sm lg:text-base"></span>
        </div>
        <div class="mb-4">
            <label class="form-lable" for="Message">Message</label>
            <textarea id="message" class="form-input" rows="5" x-model="contact_form.message" required> <?= isset($message) ? esc_attr($message) : ''; ?> </textarea>
            <span x-show="contact_errors.message" x-text="contact_errors.message" class="text-red-600 text-xs sm:text-sm lg:text-base"></span>
        </div>
        <div>
            <button type="submit" class="px-8 py-2 bg-kh_primary min-w-[200px] text-white rounded active:scale-95 transition-all duration-100">Send</button>
        </div>
    </form>

</div>