<?php
$args = array(
    'taxonomy' => KH_PARTNER_TAXONOMIES,
    'hide_empty' => false,
    'order' => 'DESC',
    'orderby' => 'date',
);
$partners = get_terms($args); ?>
<section class="section">
    <div class="section-heading">
        <h1 class="section-title">Our Partners</h1>
        <p class="section-intro">Lorem ipsum dolor, sit amet consectetur adipisicing elit. Expedita, nisi veritatis nemo velit consequuntur eos? Ipsum dolore dignissimos atque exercitationem.</p>
    </div>
    <div class="w-full py-4 lg:py-8 flex gap-4 lg:gap-8 justify-center flex-wrap">
        <?php if(!empty($partners) && !is_wp_error($partners)) : ?>
            <?php foreach($partners as $partner) :?>
                <div class="w-24 sm:w-32 sm:h-20 lg:w-32 lg:h-28">
                    <img class="w-full h-full grayscale hover:grayscale-0" src="<?= get_field("image", $partner) ?>" alt="">
                </div>
            <?php endforeach ;?>
        <?php else : ?>
            <p>No services found.</p>
        <?php endif; ?>
    </div>
</section>