<?php

namespace App\Http\Requests\Product;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $productId = $this->route('product')->id;
        return [
            'brand_id' => 'sometimes|required',
            'name' => 'sometimes|required',
            'slug' => ['sometimes','required', Rule::unique('products')->ignore($productId)],
            'intro' => 'sometimes|required',
            'desc' => 'sometimes|required'
        ];
    }
}
