<?php

namespace App\Livewire\Backend\Role;

use Livewire\Component;
use Illuminate\Support\Str;
use App\Models\Role;

class RoleManager extends Component
{
    public $roleName;
    public $slug;

    public function updatedRoleName($value)
    {
        $this->slug = Str::slug($value);
    }

    public function createRole()
    {
        $this->validate([
            'roleName' => 'required|string|unique:roles,name',
            'slug' => 'required|string|unique:roles,slug',
        ]);

        $role = Role::create([
            'name' => $this->roleName,
            'slug' => $this->slug,
        ]);

        $this->roleName = '';
        $this->slug = '';
        $this->dispatch('roleAdded');
    }

    public function cancelAction()
    {
        return $this->reset();
    }

    public function render()
    {
        return view('livewire.backend.role.role-manager');
    }
}
