<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" x-data="{ darkMode: localStorage.getItem('theme') === 'dark' }" x-init="$watch('darkMode', value => localStorage.setItem('theme', value ? 'dark' : 'light'))" :class="{ 'dark': darkMode }" x-cloak>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>{{ $title ?? 'CMS' }}</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="h-screen overflow-hidden bg-white text-black transition-all duration-300 ease-linear dark:bg-blue-950 dark:text-white">

    {{-- Alert Messge --}}
    @if (session()->has('message'))
        <div x-data="{ show: false }" x-init="setTimeout(() => show = true, 500); setTimeout(() => show=false, 3000)" class="alert alert-success fixed bottom-8 w-auto transition-all duration-300 ease-linear"
            :class="show ? 'right-4' : '-right-full'">
            {{ session('message') }}
        </div>
    @endif

    <div class="grid h-full grid-cols-12 divide-x">
        <div class="col-span-2 h-full text-center">
            <h1 class="py-8 pl-8 text-2xl font-bold text-red-600"><a href="/" wire:navigate>DShop</a></h1>
            <x-admin-nav />
        </div>
        <div class="relative col-span-10 box-border h-full">
            <div class="absolute left-0 top-0 flex w-full items-center justify-between gap-4 border-b px-4 py-4 shadow dark:shadow-lg dark:shadow-black/30">
                <div class="text-2xl font-bold text-slate-700 dark:text-slate-200">
                    {{ $title ?? '' }}
                </div>
                <div class="flex gap-4">
                    <x-theme-controller />
                    <button>
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M17.982 18.725A7.488 7.488 0 0 0 12 15.75a7.488 7.488 0 0 0-5.982 2.975m11.963 0a9 9 0 1 0-11.963 0m11.963 0A8.966 8.966 0 0 1 12 21a8.966 8.966 0 0 1-5.982-2.275M15 9.75a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                        </svg>
                    </button>

                </div>
            </div>
            <div class="relative h-full w-full overflow-y-auto pt-20">
                {{ $slot }}
            </div>
        </div>
    </div>

</body>

</html>
