<div x-data="{ openModal: false }">
    <div class="mx-auto w-[800px] p-8">
        <h1 class="mb-8 text-center text-2xl font-bold text-red-500">Update Form</h1>
        <form wire:submit.prevent="update" class="*:mb-4">
            @if (session()->has('message'))
                <div class="alert alert-success fixed bottom-8 right-4 w-auto">
                    {{ session('message') }}
                </div>
            @endif

            <div>
                <label for="name">Name</label>
                <input class="form-input" type="text" id="name" wire:model="name">
                <div>
                    @error('name')
                        <span class="error">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div>
                <label for="email">Email</label>
                <input class="form-input" type="email" id="email" wire:model="email">
                <div>
                    @error('email')
                        <span class="error">{{ $message }}</span>
                    @enderror
                </div>
            </div>
            <div>
                <div class="flex w-full items-start justify-between gap-4">
                    <label for="selectedRoles">Select Roles</label>
                    <button type="button" @click="openModal = !openModal">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                            class="size-6 text-green-400">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v6m3-3H9m12 0a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                        </svg>
                    </button>
                </div>
                <select class="form-input" id="selectedRoles" multiple wire:model='selectedRoles'>
                    @foreach ($roles as $role)
                        <option value="{{ $role->id }}" wire:key='{{ $role->id }}' @if (in_array($role->id, $selectedRoles)) selected @endif>
                            {{ $role->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="mt-16 flex justify-center gap-4 text-center">
                <button class="rounded bg-green-400 px-4 py-2 text-white hover:bg-green-600" type="submit">Update User</button>
                <button type="button">
                    <a href="{{ route('admin-users') }}" wire:navigate class="rounded bg-gray-400 px-4 py-2 text-white hover:bg-gray-600">Cancel</a>
                </button>
            </div>
        </form>

        <div>
            <livewire:backend.role.role-manager />
        </div>
    </div>
</div>
