<div class="h-full space-y-8 overflow-y-auto px-12 py-2">
    <div class="flex items-center justify-end gap-4">
        <x-search-input />
        <a href="{{ route('admin-user-create') }}" wire:navigate class="rounded bg-green-500 px-4 py-2 text-white hover:bg-green-600">Create</a>
    </div>
    <div class="h-full w-full overflow-y-auto">
        <div class="overflow-x-auto">
            <table class="table table-xs">
                <thead>
                    <tr class="text-center *:py-2">
                        <th>No.</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Roles</th>
                        <th colspan="2" class="">Articles</th>
                        <th colspan="2">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($users as $user)
                        <tr class="text-center *:py-2 hover:bg-slate-100">
                            <th>{{ $loop->iteration }}</th>
                            <td>{{ $user->name }}</td>
                            <td>{{ $user->email }}</td>
                            <td>{{ $user->roles->pluck('name')->implode(', ') }}</td>
                            <td colspan="2">{{ $user->articles_count }}</td>
                            <td class="flex justify-center gap-2" colspan="2">
                                <x-action-button type="warning">
                                    <a href="users/{{ $user->id }}/edit" class="inline-block h-full w-full px-4 py-1.5" wire:navigate>Edit</a>
                                </x-action-button>
                                <x-action-button type="danger">
                                    <button class="inline-block h-full w-full px-4 py-1.5" wire:click='delete({{ $user->id }})'
                                        wire:confirm="Are you sure?">Del</button>
                                </x-action-button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr class="bg-slate-600">
                        <th colspan="7" class="py-2 text-center text-xs text-white">Copyrights by Khant Min Aung</th>
                    </tr>
                </tfoot>
            </table>
        </div>
        <br><br>
        {{ $users->links() }}
    </div>
</div>
