<?php

use App\Livewire\Backend\ContactForm;
use App\Livewire\Backend\Dashboard;
use App\Livewire\Backend\Permission\CreatePermission;
use App\Livewire\Backend\Permission\EditPermission;
use App\Livewire\Backend\Permission\PermissionList;
use App\Livewire\Backend\Permission\UpdatePermission;
use App\Livewire\Backend\Quotation;
use App\Livewire\Backend\Role\CreateRole;
use App\Livewire\Backend\Role\EditRole;
use App\Livewire\Backend\Role\RoleList;
use App\Livewire\Backend\Role\UpdateRole;
use App\Livewire\Backend\User\CreateUser;
use App\Livewire\Backend\User\EditUser;
use App\Livewire\Backend\User\UpdateUser;
use App\Livewire\Backend\User\UserList;
use App\Livewire\Frontend\About;
use App\Livewire\Frontend\Contact;
use App\Livewire\Frontend\Home;
use App\Livewire\Frontend\Product;
use App\Livewire\Frontend\Quo;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/



Route::get('/', Home::class);
Route::get('/about', About::class);
Route::get('/contact', Contact::class);
Route::get('/quo', Quo::class);
Route::get('/products', Product::class);

Route::view('dashboard', 'dashboard')
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::view('profile', 'profile')
    ->middleware(['auth'])
    ->name('profile');

require __DIR__.'/auth.php';
